#define USEFOG

float4x4 viewProjMatrix : register (c0);
float4x4 worldMatrix : register (c4);
float4 worldEye : register (c8);
float4 fogData : register (c9);
float4 ambBase : register (c12);
float4 dirBase : register (c13);
float4 dirLight : register (c14);

#if OMNI == 1

float4 omniPosRad[12]   : register (c72);
float4 omniRGBDelta[12] : register (c84);

#elif SPOT == 1

float4 spotPosRad[4]    : register (c72);
float4 spotRGBDelta[4]  : register (c80);
float4 spotDirCone[4]   : register (c88);

#endif

struct VS_OUTPUT
{
   float4 Pos  : POSITION;
   float4 Diff : COLOR0;
#ifdef USEFOG
   float  Fog  : FOG;
#endif   
#if NUMTEX == 1
   float2 Tex0 : TEXCOORD0;
#elif NUMTEX == 2
   float2 Tex0 : TEXCOORD0;
   float2 Tex1 : TEXCOORD1;
#elif NUMTEX == 3 
   float2 Tex0 : TEXCOORD0;
   float2 Tex1 : TEXCOORD1;
   float2 Tex2 : TEXCOORD2;
#elif NUMTEX == 4
   float2 Tex0 : TEXCOORD0;
   float2 Tex1 : TEXCOORD1;
   float2 Tex2 : TEXCOORD2;
   float2 Tex3 : TEXCOORD3;
#endif
};

#if OMNI == 1

 #if NUMTEX == 1
  VS_OUTPUT vs11_gouraudDiffuseOmniT0  (float4 inPos : POSITION, float4 inNorm : NORMAL, float4 inColor : COLOR0, float2 inTex0 : TEXCOORD0)
 #elif NUMTEX == 2
  VS_OUTPUT vs11_gouraudDiffuseOmniT0T1 (float4 inPos : POSITION, float4 inNorm : NORMAL, float4 inColor : COLOR0, float2 inTex0 : TEXCOORD0, float2 inTex1 : TEXCOORD1)
 #elif NUMTEX == 3
  VS_OUTPUT vs11_gouraudDiffuseOmniT0T1T2 (float4 inPos : POSITION, float4 inNorm : NORMAL, float4 inColor : COLOR0, float2 inTex0 : TEXCOORD0, float2 inTex1 : TEXCOORD1, float2 inTex2 : TEXCOORD2)
 #elif NUMTEX == 4
  VS_OUTPUT vs11_gouraudDiffuseOmniT0T1T2T3 (float4 inPos : POSITION, float4 inNorm : NORMAL, float4 inColor : COLOR0, float2 inTex0 : TEXCOORD0, float2 inTex1 : TEXCOORD1, float2 inTex2 : TEXCOORD2, float2 inTex3 : TEXCOORD3)
 #endif
  
#elif SPOT == 1

 #if NUMTEX == 1
  VS_OUTPUT vs11_gouraudDiffuseSpotT0 (float4 inPos : POSITION, float4 inNorm : NORMAL, float4 inColor : COLOR0, float2 inTex0 : TEXCOORD0)
 #elif NUMTEX == 2
  VS_OUTPUT vs11_gouraudDiffuseSpotT0T1 (float4 inPos : POSITION, float4 inNorm : NORMAL, float4 inColor : COLOR0, float2 inTex0 : TEXCOORD0, float2 inTex1 : TEXCOORD1)
 #elif NUMTEX == 3
  VS_OUTPUT vs11_gouraudDiffuseSpotT0T1T2 (float4 inPos : POSITION, float4 inNorm : NORMAL, float4 inColor : COLOR0, float2 inTex0 : TEXCOORD0, float2 inTex1 : TEXCOORD1, float2 inTex2 : TEXCOORD2)
 #elif NUMTEX == 4
  VS_OUTPUT vs11_gouraudDiffuseSpotT0T1T2T3 (float4 inPos : POSITION, float4 inNorm : NORMAL, float4 inColor : COLOR0, float2 inTex0 : TEXCOORD0, float2 inTex1 : TEXCOORD1, float2 inTex2 : TEXCOORD2, float2 inTex3 : TEXCOORD3)
 #endif
  
#else

 #if NUMTEX == 1
  VS_OUTPUT vs11_gouraudDiffuseT0 (float4 inPos : POSITION, float4 inNorm : NORMAL, float4 inColor : COLOR0, float2 inTex0 : TEXCOORD0)
 #elif NUMTEX == 2
  VS_OUTPUT vs11_gouraudDiffuseT0T1 (float4 inPos : POSITION, float4 inNorm : NORMAL, float4 inColor : COLOR0, float2 inTex0 : TEXCOORD0, float2 inTex1 : TEXCOORD1)
 #elif NUMTEX == 3
  VS_OUTPUT vs11_gouraudDiffuseT0T1T2 (float4 inPos : POSITION, float4 inNorm : NORMAL, float4 inColor : COLOR0, float2 inTex0 : TEXCOORD0, float2 inTex1 : TEXCOORD1, float2 inTex2 : TEXCOORD2)
 #elif NUMTEX == 4
  VS_OUTPUT vs11_gouraudDiffuseT0T1T2T3 (float4 inPos : POSITION, float4 inNorm : NORMAL, float4 inColor : COLOR0, float2 inTex0 : TEXCOORD0, float2 inTex1 : TEXCOORD1, float2 inTex2 : TEXCOORD2, float2 inTex3 : TEXCOORD3)
 #endif
  
#endif
{
  VS_OUTPUT Out;
  
  // Transform vertex position into view space:
  Out.Pos = mul (viewProjMatrix, inPos);
  
  float3 worldPos = mul (worldMatrix, inPos);
  float3 worldNorm = mul (worldMatrix, inNorm.xyz);
  float magLight = saturate (dot (worldNorm, dirLight));
  Out.Diff = saturate ((dirBase * magLight) + ambBase) * inColor;

#ifdef USEFOG
  // compute fog
  float3 eyeVec = worldPos + worldEye;
  Out.Fog.x = (fogData[1] - (length (eyeVec.xyz) * fogData[0]));
#endif   
  
#if OMNI == 1
  // Compute omnilights
  float4 omni={0,0,0,0};
  for (int i=0; i<7; i++)
  {
    float intens;
    float3 omniToVert = omniPosRad[i].xyz - worldPos.xyz;
    float mag = dot (omniToVert.xyz, omniToVert.xyz);
    // check if vert in range
    if ( mag < omniPosRad[i].w) // using square distances
      if ((intens = dot (worldNorm, normalize (omniToVert))) > 0) // check backface
        omni.rgb += (intens * omniRGBDelta[i].rgb * (1.0F - (sqrt(mag) * omniRGBDelta[i].w)));
  }
  Out.Diff.rgb += omni;// - (dirBase + ambBase);
  Out.Diff.a = inColor.a;
  
#elif SPOT == 1

  // Compute spotlights
  float4 spotColor = (0,0,0,0);
  //for (int i=0; i<numActive.y; i++)
  for (int i=0; i<4; i++)
  {
    // check backface
    if (dot (worldNorm, spotDirCone[i].xyz) <= 0)
    {
      float3 spotToVert = worldPos.xyz - spotPosRad[i].xyz;
      float mag = dot (spotToVert.xyz, spotToVert.xyz);
      // check if vert in range
      if (mag < spotPosRad[i].w) // using square distances
      {
        // check if vert in cone
        mag = dot (normalize (spotToVert.xyz), spotDirCone[i].xyz);
        if (mag > spotDirCone[i].w)
        {
          float intensity = (1.0F - ( sqrt (mag) * spotRGBDelta[i].w));
          spotColor.rgb += (spotRGBDelta[i].rgb * intensity);
        }  
      }
    }
  }
  Out.Diff += spotColor;

#endif

  Out.Tex0 = inTex0;
#if NUMTEX > 1
  Out.Tex1 = inTex1;
#endif  
#if NUMTEX > 2
  Out.Tex2 = inTex2;
#endif  
#if NUMTEX > 3
  Out.Tex3 = inTex3;
#endif  
  return (Out);
}

